/*
	File:		UDialogUtils.cp

	Contains:	Dialog item utilities

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/


#include "UDialogUtils.h"

//
//	 GetDialogItemHandle
//
//	Returns the handle to the specified dialog item.
//
Handle
UDialogUtils::GetDialogItemHandle( DialogPtr theDialog, SInt16 item )
{
	SInt16		itemType;
	Handle		itemHand;
	Rect		itemRect;
	
	::GetDialogItem( theDialog, item, &itemType, &itemHand, &itemRect );
	return itemHand;
}

//
//	 SetDialogItemHandle
//
//	Sets the handle of the specified dialog item to the handle given.
//
void
UDialogUtils::SetDialogItemHandle( DialogPtr theDialog, SInt16 item, Handle handle )
{
	SInt16		itemType;
	Handle		itemHand;
	Rect		itemRect;
	
	::GetDialogItem( theDialog, item, &itemType, &itemHand, &itemRect );
	::SetDialogItem( theDialog, item, itemType, handle, &itemRect );
}

//
//	 GetDialogItemRect
//
//	Gets the bounding rectangle of the specified dialog item.
//
void
UDialogUtils::GetDialogItemRect( DialogPtr theDialog, SInt16 item, Rect& rect )
{
	SInt16		itemType;
	Handle		itemHand;
	
	::GetDialogItem( theDialog, item, &itemType, &itemHand, &rect );
}

//
//	 SetDialogItemRect
//
//	Sets the bounding rectangle of the specified dialog item to the given rectangle.
//
void
UDialogUtils::SetDialogItemRect( DialogPtr theDialog, SInt16 item, const Rect& rect )
{
	SInt16		itemType;
	Handle		itemHand;
	Rect		itemRect;
	
	::GetDialogItem( theDialog, item, &itemType, &itemHand, &itemRect );
	::SetDialogItem( theDialog, item, itemType, itemHand, &rect );
}

//
//	 FlashDialogItem
//
//	This routine is used to flash a button for the cases when the user presses a key that
//	'clicks' a dialog button. If the item specified is not a button, the routine does nothing.
//
void
UDialogUtils::FlashDialogItem( DialogPtr theDialog, SInt16 item )
{
	ControlHandle	control;
	DELAY_LONG		ticks;
	OSErr			err;
	
	err = ::GetDialogItemAsControl( theDialog, item, &control );
	if ( err == noErr )
	{
		HiliteControl( control, 1 );
		Delay( 8, &ticks );
		HiliteControl( control, 0 );
	}
}

//
//	 ToggleCheckBox
//
//	This routine simply toggles a check box.
//
void
UDialogUtils::ToggleCheckBox( DialogPtr dialog, SInt16 item )
{
	SInt16	newState = 0;
	
	if ( GetDialogItemValue( dialog, item ) == 0 )
		newState = 1;
	SetDialogItemValue( dialog, item, newState );
}

//
//	 SetDialogItemValue
//
//	This routine sets the value of the given item to the value passed in.
//
void
UDialogUtils::SetDialogItemValue( DialogPtr dialog, SInt16 item, SInt16 value )
{
	ControlHandle	control;
	OSErr			err;
		
	err = ::GetDialogItemAsControl( dialog, item, &control );
	if ( err ) return;
	
	::SetControlValue( control, value );
}

//
//	 GetDialogItemValue
//
//	This routine gets the value of the given item and returns it.
//
SInt16
UDialogUtils::GetDialogItemValue( DialogPtr dialog, SInt16 item )
{
	ControlHandle	control;
	OSErr			err;
	
	err = ::GetDialogItemAsControl( dialog, item, &control );
	if ( err ) return 0;
	
	return ::GetControlValue( control );
}

//
//	 SetDialogItemText
//
//	This routine sets the text of the given item to the value passed in.
//
void
UDialogUtils::SetDialogItemText( DialogPtr dialog, SInt16 item, StringPtr text )
{
	SInt16		itemType;
	Handle		itemHand;
	Rect		itemRect;
	ControlHandle	root;
	
	if ( GetRootControl( dialog, &root ) == noErr )
		::GetDialogItemAsControl( dialog, item, (ControlHandle*)&itemHand );
	else
		::GetDialogItem( dialog, item, &itemType, &itemHand, &itemRect );
	::SetDialogItemText( itemHand, text );
}

//
//	 GetDialogItemText
//
//	This routine gets the text of the given item and returns it.
//
void
UDialogUtils::GetDialogItemText( DialogPtr dialog, SInt16 item, StringPtr text )
{
	SInt16		itemType;
	Handle		itemHand;
	Rect		itemRect;
	
	::GetDialogItem( dialog, item, &itemType, &itemHand, &itemRect );
	::GetDialogItemText( itemHand, text );
}


//
//	 EnableDialogItem
//
//	This routine enables or disables a specified item. enableIt is true for enabling, false
//	to disable.
//
void
UDialogUtils::EnableDialogItem( DialogPtr dialog, SInt16 item, Boolean enableIt )
{
	ControlHandle		control;
	OSErr				err;
	
	err = ::GetDialogItemAsControl( dialog, item, &control );
	if ( err ) return;
	
	if ( enableIt )
		::ActivateControl( control );
	else
	{
		::DeactivateControl( control );
	}
}

//
//	 SetFontStyle
//
//	This routine sets the font style of a dialog item.
//
void
UDialogUtils::SetFontStyle( DialogPtr dialog, SInt16 item, ControlFontStyleRec& style )
{
	ControlHandle 	control;
	OSErr			err;
	
	err = ::GetDialogItemAsControl( dialog, item, &control );
	
	if ( err == noErr )
		::SetControlFontStyle( control, &style );
}
